package gov.va.med.mhv.rxrefill.data.model;

import java.io.Serializable;
import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;

@Entity
@Table(name = "PRESCRIPTION_REQUESTS")
public class PrescriptionRequest implements Serializable {

	private static final long serialVersionUID = -1995615031180684619L;

	@Id
	@Column(name = "PRESCRIPTION_REQUEST_ID_SEQ")
	@GeneratedValue(strategy = GenerationType.AUTO)
	private Long id;

	@Column(name = "OPLOCK")
	private Integer oplock = 1;

	@Column(name = "CREATED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date createdDate;

	@Column(name = "MODIFIED_DATE")
	@Temporal(TemporalType.TIMESTAMP)
	private Date modifiedDate;

	@Column(name = "STATUS")
	private String status;

	@Column(name = "REQUEST_ID_SEQ", insertable = false, updatable = false)
	private Long requestId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "REQUEST_ID_SEQ")
	private Request parentRequest;

	@Column(name = "PRESCRIPTIONS_PRESCRIPTION_ID", insertable = false, updatable = false)
	private Long prescriptionId;

	@ManyToOne(fetch = FetchType.EAGER)
	@JoinColumn(name = "PRESCRIPTIONS_PRESCRIPTION_ID")
	private Prescription prescription;

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	public Integer getOplock() {
		return oplock;
	}

	public void setOplock(Integer oplock) {
		this.oplock = oplock;
	}

	public Date getCreatedDate() {
		return createdDate;
	}

	public void setCreatedDate(Date createdDate) {
		this.createdDate = createdDate;
	}

	public Date getModifiedDate() {
		return modifiedDate;
	}

	public void setModifiedDate(Date modifiedDate) {
		this.modifiedDate = modifiedDate;
	}

	public String getStatus() {
		return status;
	}

	public void setStatus(String status) {
		this.status = status;
	}


	public Long getRequestId() {
		return requestId;
	}

	public void setRequestId(Long requestId) {
		this.requestId = requestId;
	}

	public Request getParentRequest() {
		return parentRequest;
	}

	public void setParentRequest(Request parentRequest) {
		this.parentRequest = parentRequest;
	}


	public Long getPrescriptionId() {
		return prescriptionId;
	}

	public void setPrescriptionId(Long prescriptionId) {
		this.prescriptionId = prescriptionId;
	}

	public Prescription getPrescription() {
		return prescription;
	}

	public void setPrescription(Prescription prescription) {
		this.prescription = prescription;
	}

	public String toString() {
		StringBuffer sb = new StringBuffer();

		sb.append("id : " + id);
		sb.append(", oplock : " + oplock);
		sb.append(", createdDate : " + createdDate);
		sb.append(", status : " + status);
		sb.append(", modifiedDate : " + modifiedDate);
		sb.append(", parentRequest : " + parentRequest);
		sb.append(", prescriptionId : " + prescriptionId);

		return sb.toString();
	}

}
